﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reactive;
using System.Reactive.Concurrency;
using System.Reactive.Linq;
using System.Text;
using System.Threading.Tasks;

namespace BasicRx
{
    class Example18
    {
        public static void WatchFoldersIndefinite()
        {
            string path = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
            var w = new FileSystemWatcher(path);
            IObservable<EventPattern<FileSystemEventArgs>> changes =
                Observable.FromEventPattern<FileSystemEventHandler, FileSystemEventArgs>(
                    h => w.Changed += h, h => w.Changed -= h);
            w.IncludeSubdirectories = true;
            w.EnableRaisingEvents = true;

            IObservable<IGroupedObservable<string, string>> folders =
                from change in changes
                group Path.GetFileName(change.EventArgs.FullPath)
                   by Path.GetDirectoryName(change.EventArgs.FullPath);

            folders.Subscribe(f =>
            {
                Console.WriteLine("New folder ({0})", f.Key);
                f.Subscribe(file =>
                    Console.WriteLine("File changed in folder {0}, {1}", f.Key, file));
            });

            while (true)
            {
                Scheduler.Default.Yield();
            }
        }
    }
}
